<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
            color: #333;
        }
        .email-container {
            max-width: 600px;
            margin: 20px auto;
            background: #fff;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 8px;
        }
        .header {
            text-align: center;
            font-size: 24px;
            font-weight: bold;
            color: #2c3e50;
        }
        .content {
            margin: 20px 0;
            font-size: 16px;
        }
        .content p {
            margin: 8px 0;
        }
        .footer {
            margin-top: 20px;
            font-size: 14px;
            color: #777;
            text-align: center;
        }
        .footer a {
            color: #3498db;
            text-decoration: none;
        }
        .footer a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">Car Publish Request</div>
        <div class="content">
            <p><strong>Company Name:</strong> <?= esc($companyname) ?></p>
            <p><strong>VAT Code:</strong> <?= esc($vatcode) ?></p>
            <p><strong>City:</strong> <?= esc($city) ?></p>
            <p>is requesting to publish this car:</p>
            <p><strong>Car Brand:</strong> <?= esc($carbrand) ?></p>
            <p><strong>Car Code:</strong> <?= esc($carcode) ?></p>
            <p><strong>Car VIN:</strong> <?= esc($carvin) ?></p>
            <p><a href="<?= esc($admin_url) ?>">View Car in Admin Panel</a></p>
        </div>
        <div class="footer">
            <p>
                <strong>ZadioCars Team</strong><br>
                Zadio EOOD<br>
                Ruse, Bulgaria<br>
                Phone: +359 877 666 972<br>
                Email: <a href="mailto:cars@zadio.bg">cars@zadio.bg</a>
            </p>
        </div>
    </div>
</body>
</html>
