<?php namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model{
  protected $table = 'users';
  protected $allowedFields = ['companyname','vatnumber','country','district','city','address', 'firstname', 'lastname', 'email','website','phone', 'password','contactemail', 'updated_at','active','commission_type','commission_min','commission_abs','commission_percent','hide_zadio','access'];
  protected $beforeInsert = ['beforeInsert'];
  protected $beforeUpdate = ['beforeUpdate'];

  protected function beforeInsert(array $data){
    $data = $this->passwordHash($data);
    $data['data']['created_at'] = date('Y-m-d H:i:s');

    return $data;
  }

  protected function beforeUpdate(array $data){
    $data = $this->passwordHash($data);
    $data['data']['updated_at'] = date('Y-m-d H:i:s');
    return $data;
  }

  protected function passwordHash(array $data){
    if(isset($data['data']['password']))
      $data['data']['password'] = password_hash($data['data']['password'], PASSWORD_DEFAULT);

    return $data;
  }


  /*
  04-01-2025 Access roles are as follows:
  0: Blocked (No access)
  1: Read-only Seller
  2: Read-only Buyer
  3: Read-only Seller & Buyer
  4: Read-Write Seller
  5: Read-Write Buyer
  6: Read-Write Seller & Buyer


  */
  public function getUsersByRole($role){

    $db = db_connect();
    
    switch($role){
      case 'All':
        $where = "";
        break;
      case 'New':
        $where = "WHERE active=0";
        break;
      case 'Admin':
        $where = "WHERE isadmin=1";
        break;
      case 'Buyer':
        $where = "WHERE access in(2,3,5,6)";
        break;
      case 'Seller':
        $where = "WHERE access in(1,3,4,6)";
        break;
      default:
        return [];
    }
    $query = $db->query("SELECT * FROM `users` ". $where. " order by id asc");
    return $query->getResult('array');
  }

  public function getUsrMsg($usr){
    $db = db_connect();
	$query = $db->query("SELECT * FROM `user_msg` WHERE user=".$usr);
    return $query->getResult('array');
    
  }

  public function get_active_users_count(){
    $db = db_connect();
    $query = $db->query("SELECT count(*) as cnt FROM `users` WHERE active=1");
    return $query->getResult('array')[0];
  }
  public function get_active_sellers_count(){
    $db = db_connect();
    $query = $db->query("SELECT count(*) as cnt FROM `users` WHERE access in(1,3,4,6) and active=1");
    return $query->getResult('array')[0];
  }

  public function get_active_buyers_count(){
    $db = db_connect();
    $query = $db->query("SELECT count(*) as cnt FROM `users` WHERE access in(2,3,5,6) and active=1");
    return $query->getResult('array')[0];
  }

  public function get_active_clients_count(){
    //TODO after implementing client
    return 0;
  }

  public function get_approval_pending_users_count(){
    $db = db_connect();
    $query = $db->query("SELECT count(*) as cnt FROM `users` WHERE active=0");
    return $query->getResult('array')[0];
  }

  public function get_blocked_users_count(){
    $db = db_connect();
    $query = $db->query("SELECT count(*) as cnt FROM `users` WHERE access=0");
    return $query->getResult('array')[0];
  }

}
