<?php namespace Config;
$routes = Services::routes(true);
if (file_exists(SYSTEMPATH . 'Config/Routes.php'))
{
	require SYSTEMPATH . 'Config/Routes.php';
}
$routes->setDefaultNamespace('App\Controllers');
//$routes->setDefaultController('Users');

$routes->setDefaultController('Main');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

$routes->match(['get','post'],'/'                , 'Users::login');
$routes->match(['get','post'],'/userlist'     	 , 'Users::userlist' ,['filter' => 'auth']);
$routes->match(['get','post'],'/edituser/(:any)'  , 'Users::edituser/$1' ,['filter' => 'auth']);


$routes->match(['get','post'],'/brandmodels'     , 'MainController::brandmodels'     		);



$routes->match(['get','post'],'/login'       	, 'Users::login'                        );
$routes->match(['get','post'], '/register'   	, 'Users::register'       			   	 );
$routes->match(['get','post'], '/confirmreg' 	, 'Users::confirmreg'       			);
$routes->get ('logout'                     	 	, 'Users::logout');
$routes->match(['get','post'],'/profile'     	, 'Users::profile'                      ,['filter' => 'auth']);
$routes->match(['get','post'],'/changepwd'     	, 'Users::changepwd'                    ,['filter' => 'auth']);


$routes->get ('dashboard'                  		, 'DashboardController::index'           ,['filter' => 'auth']);
$routes->get ('dashboard/search'           		, 'DashboardController::search'          ,['filter' => 'auth']);
$routes->post('dashboard/search'           		, 'DashboardController::search'          ,['filter' => 'auth']);
$routes->get ('dashboard/list'             		, 'DashboardController::list'            ,['filter' => 'auth']);
$routes->post('dashboard/list'             		, 'DashboardController::list'            ,['filter' => 'auth']);

$routes->match(['get','post'],'cars'            		, 'CarsController::index'           	,['filter' => 'auth']);
$routes->match(['get','post'],'cars/edit/(:any)'  		, 'CarsController::edit/$1'           	,['filter' => 'auth']);
$routes->match(['get','post'],'cars/uploadimg/(:any)'  	, 'CarsController::uploadimg/$1'        ,['filter' => 'auth']);
$routes->match(['get','post'],'cars/brandmodels' 		, 'CarsController::brandmodels'     	,['filter' => 'auth']);
$routes->match(['get','post'],'settings'            	, 'SettingsController::index'           ,['filter' => 'auth']);

$routes->match(['get','post'],'company'         	    , 'SettingsController::company'           	,['filter' => 'auth']);
$routes->match(['get','post'],'contacts'         	    , 'SettingsController::contacts'          ,['filter' => 'auth']);
$routes->match(['get','post'],'editcontact/(:any)'      , 'SettingsController::editcontact/$1'   ,['filter' => 'auth']);
$routes->match(['get','post'],'brands'             		, 'SettingsController::brands'      	,['filter' => 'auth']);
$routes->match(['get','post'],'models'             		, 'SettingsController::models'      	,['filter' => 'auth']);
$routes->match(['get','post'],'countries'             	, 'SettingsController::countries'      	,['filter' => 'auth']);



if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php'))
{
	require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
