<?php namespace Config;
$routes = Services::routes(true);
if (file_exists(SYSTEMPATH . 'Config/Routes.php'))
{
	require SYSTEMPATH . 'Config/Routes.php';
}
$routes->setDefaultNamespace('App\Controllers');
//$routes->setDefaultController('Users');

$routes->setDefaultController('Main');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

$routes->match(['get','post'],'/'                      , 'MainController::index'               );
$routes->match(['get','post'],'/brandmodels' 		   , 'MainController::brandmodels'     		);

$routes->match(['get','post'],'/login'       	, 'Users::login'                        );
$routes->match(['get','post'], '/register'   	, 'Users::register'       			   	 );
$routes->match(['get','post'], '/confirmreg' 	, 'Users::confirmreg'       			);
$routes->get ('logout'                     	 	, 'Users::logout');
$routes->match(['get','post'],'/profile'     	, 'Users::profile'                      ,['filter' => 'auth']);

$routes->get ('dashboard'                  		, 'DashboardController::index'           ,['filter' => 'auth']);
$routes->get ('dashboard/search'           		, 'DashboardController::search'          ,['filter' => 'auth']);
$routes->post('dashboard/search'           		, 'DashboardController::search'          ,['filter' => 'auth']);
$routes->get ('dashboard/list'             		, 'DashboardController::list'            ,['filter' => 'auth']);
$routes->post('dashboard/list'             		, 'DashboardController::list'            ,['filter' => 'auth']);

$routes->match(['get','post'],'cars'            		, 'CarsController::index'           	,['filter' => 'auth']);
$routes->match(['get','post'],'cars/edit/(:any)'  		, 'CarsController::edit/$1'           	,['filter' => 'auth']);
$routes->match(['get','post'],'cars/uploadimg/(:any)'  	, 'CarsController::uploadimg/$1'        ,['filter' => 'auth']);
$routes->match(['get','post'],'cars/brandmodels' 		, 	'CarsController::brandmodels'     			 ,['filter' => 'auth']);



if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php'))
{
	require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
