<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\CarsModel;
use App\Models\FavoritesModel;

class FavoritesController extends BaseController
{
	public function index()
	{
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }
		$carsModel = new CarsModel();
		$favoritesModel = new FavoritesModel();





		$data['filter']=null;
		$cars=$favoritesModel->getFavoritesByUser($usr);
		
		
		for($j=0;$j<count($cars);$j++)
		{
			$imgs=$carsModel->get_imgs(($cars[$j])['code']);
			$cnt=count($imgs);
			if($cnt>0)
			{
				($cars[$j])['img']=($imgs[0])['url'];
			}
			
		}
		
		$data['cars']=$cars;

		
		return view('favorites/index',$data);   
        




	}
	
}
