<?php namespace App\Controllers;
use App\Models\CarsModel;
use App\Models\TemplatesModel;
use App\Models\FavoritesModel;

class MainController extends BaseController
{
   public function index()
   {
	 
		$data = ['data' => ''];
        $us = session()->get('id');
		$carsModel = new CarsModel();
		
		$session = session();
		$usr = session()->get('id');
			
		$brands=$carsModel->get_aprroved_brands();
		$fuels= $carsModel->get_all_fuels();
		$drivetrains= $carsModel->get_all_drivetrains();
		$gearboxes= $carsModel->get_all_gearboxes();



		if($this->request->getMethod()== 'POST')
		{
			
			// $filter=array(
			// 'brand' =>$this->request->getVar('brand'),
			// 'model' =>$this->request->getVar('model1'),
			// 'fuel' => $this->request->getVar('fuel'),
			// 'searchstr' => $this->request->getVar('searchStr')
			// );


			$filter = array(
				'brand' => $this->request->getVar('brand'),
				'model1' => $this->request->getVar('model1'),
				'fuel' => $this->request->getVar('fuel'),
				'gearbox' => $this->request->getVar('gearbox'),
				'drivetrain' => $this->request->getVar('drivetrain'),
				'minPrice' => $this->request->getVar('price_min'),
				'maxPrice' => $this->request->getVar('price_max'),
				'minKm' => $this->request->getVar('km_min'),
				'maxKm' => $this->request->getVar('km_max'),
				'minYear' => $this->request->getVar('manuf_year_min'),
				'maxYear' => $this->request->getVar('manuf_year_max'),
				'engine_power_min' => $this->request->getVar('engine_power_min'),
				'engine_power_max' => $this->request->getVar('engine_power_max'),
			);


			$data['filter']=$filter;

			// $cars = $carsModel->filter_aprroved_cars($filter);

			$cars=$this->getCars($filter);
			//var_dump($filter);
			//exit;
        }
		else
		{
			$data['filter']=null;
			$cars=$carsModel->get_aprroved_cars();
			$search_limits=$carsModel->get_search_limits();
			
			$nofilter = array(
				'brand' => 'All brands',
				'model1' => 'All models',
				'fuel' => 'All fuels',
				'gearbox' => 'All gearboxes',
				'drivetrain' => 'All drivetrains',
				'price_min' => $search_limits['min_price'],
				'price_max' => $search_limits['max_price'],
				'km_min' => $search_limits['min_km'],
				'km_max' => $search_limits['max_km'],
				'manuf_year_min' => $search_limits['min_year'],
				'manuf_year_max' => $search_limits['max_year'],
				'engine_power_min' => $search_limits['engine_power_min'],
				'engine_power_max' => $search_limits['engine_power_max']
			);
			//$data['nofilter']=$nofilter;
			
			
		}
		for($j=0;$j<count($cars);$j++)
		{
			$imgs=$carsModel->get_imgs(($cars[$j])['code']);
			$cnt=count($imgs);
			if($cnt>0)
			{
				($cars[$j])['img']=($imgs[0])['url'];
			}
			
		}
		
		$searchProps=array();

		$db = db_connect();
		$sqlstr = "SELECT `additionals` FROM `advanced_search` LIMIT 1";
		$query = $db->query($sqlstr);
		$addArr = $query->getResult('array');
		$obj = $addArr[0];
		$allAdt=json_decode($obj['additionals'],true);
		//var_dump($allAdt['properties']);exit;
		$sqlstr = "SELECT * FROM `cars` where status=3";
		$query1 = $db->query($sqlstr);
		$allCars = $query1->getResult('array');
		
		foreach ($allCars as $carItem)
		{
			//var_dump($carItem);exit;
			
			$carrAddt=$carItem['additionals'];
			
			//var_dump($carItem);exit;
			
			$addtProps = json_decode($carrAddt,true);
			foreach($addtProps as $addtProp)
			{
				$propName=$addtProp['name'];
			    //find name in allAdt; if exists push it to $searchProps
				foreach ($allAdt as $adtItem)
				{
					if(isset($adtItem[$propName]) && is_array($adtItem[$propName]))
					{
						//var_dump($adtItem[$propName]);exit;
						array_push($searchProps,$propName);
					}
					
				}
				
			}
			$unqProps = array_unique($searchProps);
			//var_dump('<br><br><br><br>'); var_dump($unqProps);exit;
			
		}
		
		$decoded = json_decode($obj['additionals'], true);
		
		//build the final Array
		
		$finalArr=array();
		foreach ($allAdt as $adtItem) 
		{
			//find in the list
			foreach ($unqProps as $propName)
			{
					if(isset($adtItem[$propName]) && is_array($adtItem[$propName]))
					{
						//var_dump($adtItem[$propName]);exit;
						array_push($finalArr,array($propName=>$adtItem[$propName]));
						//break;
					}
			}
		}
		//var_dump('<br><br><br><br>'); var_dump(json_encode($finalArr));exit;
		
		 
		
		
		// Ensure 'properties' exists and is an array
		if (isset($decoded['properties']) && is_array($decoded['properties'])) {
			$filteredProperties = array_filter(
				$decoded['properties'], // Access the 'properties' array here
				function ($item) {
					return (isset($item['advanced-searchable']) && $item['advanced-searchable'] === '1') || 
						   (isset($item['type']) && $item['type'] === 'label');
				}
			);
		} else {
			$filteredProperties = []; // Default to an empty array if 'properties' doesn't exist
		}
		
		// Build the result array
		$result = [
			'name' => $decoded['name'] ?? '',
			'title' => $decoded['title'] ?? '',
			'description' => $decoded['description'] ?? '',
			'method' => $decoded['method'] ?? '',
			'enctype' => $decoded['enctype'] ?? '',
			'action' => $decoded['action'] ?? '',
			'properties' => $filteredProperties
		];

		// Encode the filtered properties back to JSON
		$result = json_encode($result, JSON_PRETTY_PRINT);

		$data['searchable_additionals']=$result;
		//var_dump($cars);
		$data['brands']=$brands;
		$data['cars']=$cars;
		$data['fuels']=$fuels;
		$data['gearboxes']=$gearboxes;
		$data['drivetrains']=$drivetrains;
		
		echo view('main/index',$data);
		
   }
   
   private function getCars($filters){
		// Connect to the database
		$db = db_connect();

		// Get the `cars` table

		$builder = $db->table('cars');


		// Apply filters to the query dynamically
		if (!empty($filters['brand'])) {
			$builder->where('brand', $filters['brand']);
		}
		if (!empty($filters['model1'])) {
			$builder->like('model', $filters['model1']);
		}
		if (!empty($filters['fuel'])) {
			$builder->where('fuel', $filters['fuel']);
		}
		if (!empty($filters['gearbox'])) {
			$builder->where('gear_box', $filters['gearbox']);
		}
		if (!empty($filters['drivetrain'])) {
			$builder->where('drivetrain', $filters['drivetrain']);
		}
		if (!empty($filters['minPrice'])) {
			$builder->where('price_bgn >=', $filters['minPrice']);
		}
		if (!empty($filters['maxPrice'])) {
			$builder->where('price_bgn <=', $filters['maxPrice']);
		}
		if (!empty($filters['minKm'])) {
			$builder->where('km >=', $filters['minKm']);
		}
		if (!empty($filters['maxKm'])) {
			$builder->where('km <=', $filters['maxKm']);
		}
		if (!empty($filters['minYear'])) {
			$builder->where('date_manufacture >=', $filters['minYear']);
		}
		if (!empty($filters['maxYear'])) {
			$builder->where('date_manufacture <=', $filters['maxYear']);
		}
		if (!empty($filters['engine_power_min'])) {

			$builder->where('engine_power_hp >=', $filters['engine_power_min']);
			
		}
		if (!empty($filters['engine_power_max'])) {

			$builder->where('engine_power_hp <=', $filters['engine_power_max']);
		}
		$builder->where ('status', 3);

		// var_dump($filters);
		// Query the database to fetch the filtered cars
		$cars = $builder->get()->getResultArray();
		// var_dump($cars);
		return $cars;
   }

	public function getQuickOptions(){
 		// Connect to the database
		$db = db_connect();

		// Get the `cars` table

        $builder = $db->table('cars');

        // Get filters from query parameters
        $filters = $this->request->getGet();
		
		

        // Apply filters to the query dynamically
        if (!empty($filters['brand'])) {
            $builder->where('brand', $filters['brand']);
        }
        if (!empty($filters['model1'])) {
            $builder->like('model', $filters['model1']);
        }
        if (!empty($filters['fuel'])) {
            $builder->where('fuel', $filters['fuel']);
        }
        if (!empty($filters['gearbox'])) {
            $builder->where('gear_box', $filters['gearbox']);
        }
        if (!empty($filters['drivetrain'])) {
            $builder->where('drivetrain', $filters['drivetrain']);
        }
        if (!empty($filters['minPrice'])) {
            $builder->where('price_bgn >=', $filters['minPrice']);
        }
        if (!empty($filters['maxPrice'])) {
            $builder->where('price_bgn <=', $filters['maxPrice']);
        }
        if (!empty($filters['minKm'])) {
            $builder->where('km >=', $filters['minKm']);
        }
        if (!empty($filters['maxKm'])) {
            $builder->where('km <=', $filters['maxKm']);
        }
        if (!empty($filters['minYear'])) {
            $builder->where('date_manufacture >=', $filters['minYear']);
        }
        if (!empty($filters['maxYear'])) {
            $builder->where('date_manufacture <=', $filters['maxYear']);
        }
		if (!empty($filters['engine_power_min'])) {

			$builder->where('engine_power_hp >=', $filters['engine_power_min']);
			
		}
		if (!empty($filters['engine_power_max'])) {

			$builder->where('engine_power_hp <=', $filters['engine_power_max']);
		}
		$builder->where ('status', 3);
        // Query the database to fetch the filtered cars
        $cars = $builder->get()->getResultArray();

        // Extract the unique filterable options from the filtered cars data
        $options = [
            'brand' => $this->getUniqueValuesFromResults($cars, 'brand'),
            'model1' => $this->getUniqueValuesFromResults($cars, 'model'),
            'fuel' => $this->getUniqueValuesFromResults($cars, 'fuel'),
            'gearbox' => $this->getUniqueValuesFromResults($cars, 'gear_box'),
            'drivetrain' => $this->getUniqueValuesFromResults($cars, 'drivetrain'),
            'price_min' => $this->getMinValueFromResults($cars, 'price_bgn'),
            'price_max' => $this->getMaxValueFromResults($cars, 'price_bgn'),
            'km_min' => $this->getMinValueFromResults($cars, 'km'),
            'km_max' => $this->getMaxValueFromResults($cars, 'km'),
            'manuf_year_min' => $this->getMinValueFromResults($cars, 'date_manufacture'),
            'manuf_year_max' => $this->getMaxValueFromResults($cars, 'date_manufacture'),
			'engine_power_min' => $this->getMinValueFromResults($cars, 'engine_power_hp'),
			'engine_power_max' => $this->getMaxValueFromResults($cars, 'engine_power_hp'),

        ];

        // Return the options as JSON
        return $this->response->setJSON($options);
	}
	public function getFilteredOptions()
    {
       
    }
    // Extract unique values for a given column from filtered results
    private function getUniqueValuesFromResults($cars, $column)
    {
        $values = array_map(function ($car) use ($column) {
            return $car[$column];
        }, $cars);
        return array_values(array_unique($values));
    }

    // Get the minimum value from the filtered results
    private function getMinValueFromResults($cars, $column)
    {
        $values = array_column($cars, $column);
        return min($values);
    }

    // Get the maximum value from the filtered results
    private function getMaxValueFromResults($cars, $column)
    {
        $values = array_column($cars, $column);
        return max($values);
    }

    public function cardetails($code,$barandmodel){
        
		$data = ['data' => ''];
		$carsModel = new CarsModel();
		$data['car']=$carsModel->get_approved_by_code($code);
		$carimgs=$carsModel->get_imgs($code);
		$data['imgs']=$carimgs;

		$model = new TemplatesModel();

		$ctcb = $model->get_commercial_terms_buyers_by_id(1)['ctcb'];
		
		$favorites_model = new FavoritesModel();
		$userId = session()->get('id');
		$carId = $data['car']['id'];
		$data['car_id'] = $carId; // Car ID to be used in the view
		$data['favorite_status'] = $favorites_model->isFavorite($userId, $carId); // Check if the car is favorited

		$data['ctcb'] = $ctcb;
		//var_dump($data['car']);exit;
		echo view('main/cardetails',$data);
	}
	
	public function galery($code){
        $carsModel = new CarsModel();
		$data = ['data' => ''];
		$carimgs=$carsModel->get_imgs($code);
		$data['imgs']=$carimgs;
		//var_dump($data['car']);exit;
		echo view('main/gallery',$data);
	}
   
   public function brandmodels(){
        
		//log_message('error', 'Ajax call');
        $brand=$this->request->getVar('brand');
		log_message('error', 'Value of brand is '.$brand);
		
		$db = db_connect();
		$sqlstr="SELECT distinct `model` as  `model_name`  FROM `cars` WHERE  `brand`='$brand' and status=3";
		log_message('error',$sqlstr);
		$query=$db->query($sqlstr);
		
		echo(json_encode($query->getResult('array')));
		exit;
	}

	public function fueltypes(){
		
		//log_message('error', 'Ajax call');
		$model=$this->request->getVar('model');
		$brand=$this->request->getVar('brand');
		log_message('error', 'Value of model is '.$model);
		
		$db = db_connect();
		$sqlstr="SELECT distinct `fuel` as  `fuel_type`  FROM `cars` WHERE  `brand`='$brand' and `model` ='$model' and status=3";
		log_message('error',$sqlstr);
		$query=$db->query($sqlstr);
		
		echo(json_encode($query->getResult('array')));
		exit;
	}


	public function toggleFavorite()
	{
		$carId = $this->request->getPost('car_id');

		$userId = session()->get('id');
	
		if (!$carId || !$userId) {
			return $this->response->setJSON(['success' => false, 'message' => 'Invalid request.']);
		}
	
		$favoritesModel = new FavoritesModel();
	
		if ($favoritesModel->isFavorite($userId, $carId)) {
			$favoritesModel->removeFavorite($userId, $carId);
			return $this->response->setJSON(['success' => true, 'action' => 'removed']);
		} else {
			$favoritesModel->addFavorite($userId, $carId);
			return $this->response->setJSON(['success' => true, 'action' => 'added']);
		}
	}
	
   public function buycar($code,$model)
   {
	   echo 'Buy Car';
	   exit;
   }   
   
   
  
}
