<?php 
namespace App\Controllers;
use App\Models\UserModel;
class Users extends BaseController
{
	
	/*
	public function index()
	{
		$data = [];
		$data = ['data' => ''];
		helper(['form']);
		if ($this->request->getMethod() == 'post') {
			$rules = [
				'username' => 'required|min_length[3]|max_length[20]',
				'password' => 'required|min_length[8]|max_length[255]|validateUser[username,password]',
			];
			$errors = [
				'password' => [
					'validateUser' => 'Username or Password don\'t match'
				]
			];
			if (! $this->validate($rules, $errors)) {
				$data['validation'] = $this->validator;
			}else{
				$model = new UserModel();
				$user = $model->where('email', $this->request->getVar('email'))->first();
				$this->setUserSession($user);
				return redirect()->to('dashboard');
			}
		}
		return view('user/login', $data);
	}
	*/
	
	private function setUserSession($user){
		
		$seller=0;
		$buyer=0;
		if($user['access']==1 || $user['access']==3 || $user['access']==4 || $user['access']==6)
			$seller=1;
		
	    if($user['access']==2 || $user['access']==3 || $user['access']==5 || $user['access']==6)
			$buyer=1;
	    
		if($user['access']<4)
			$readonly=1;
	    else
			$readonly=0;
		
		/***********************************
		0 Blocked (No access)
		1 Read-only Seller
		2 Read-only Buyer
		3 Read-only Seller & Buyer
		4 Read-Write Seller
		5 Read-Write Buyer
		6 Read-Write Seller & Buyer
		************************************/
		$data = [
			'id' => $user['id'],
			'companyname' => $user['companyname'],
			'username' => $user['email'],
			'firstname' => $user['firstname'],
			'lastname' => $user['lastname'],
			'email' => $user['email'],
			'buyer' => $buyer,
			'seller' => $seller,
			'readonly' => $readonly,
			'isLoggedIn' => true,
			'commission_abs_sale'=> $user['commission_abs'],
			'commission_percent_sale'=> $user['commission_percent'],
			'commission_min_sale'=> $user['commission_min'],
			'commission_type_sale'=> $user['commission_type'],
			'hide_zadio'=> $user['hide_zadio']
			];
		session()->set($data);
		return true;
	}
	
	
	
	public function login()
	{
		$data = [];
		$data = ['data' => ''];
		helper(['form']);
		if ($this->request->getMethod() == 'POST') {
			$rules = [
				'email' => 'required|min_length[3]|max_length[100]',
				'password' => 'required|min_length[8]|max_length[255]|validateUser[username,password]',
			];
			$errors = [
				'password' => [
					'validateUser' => 'Email or Password don\'t match'
				]
			];
			if (! $this->validate($rules, $errors)) {
				$data['validation'] = $this->validator;
			}else{
				$model = new UserModel();
				$user = $model->where('email', $this->request->getVar('email'))->first();
				$this->setUserSession($user);
				//var_dump(session()->get('seller'));
				//var_dump($user['access']);
				//exit;
				if(session()->get('seller')==1)
				//Radu a cerut redirect spre dashboard in orice caz
					return redirect()->to('dashboard');
					//return redirect()->to('cars');
				else
					return redirect()->to('dashboard');
			}
		}
		return view('user/login', $data);
	}
	
	public function register(){
		//$libpath=realpath(dirname(__DIR__) . '/..');
		//include_once $libpath.'/send_smtp.php';
		//sendMyMsg('edi.hermann@lemonbyte.ro','edi.hermann@lemonbyte.ro','New registration in cars.zadio.bg','zzzzzzzzzz');
		$data['districts']=array();		
		$data = [];
		helper(['form']);
		
		if ($this->request->getMethod() == 'POST') {
			
			$rules = [
				'companyname' => 'required|min_length[3]|max_length[50]',
				'vatnumber' => 'required|min_length[8]|max_length[12]|is_unique[users.vatnumber]',
				'country' => 'required|min_length[1]|max_length[50]',
				'district' => 'required|min_length[1]|max_length[50]',
				'city' => 'required|min_length[1]|max_length[50]',
				'address' => 'required|min_length[1]|max_length[200]',
				'firstname' => 'required|min_length[1]|max_length[20]',
				'lastname' => 'required|min_length[1]|max_length[20]',
				'email' => 'required|min_length[6]|max_length[50]|valid_email|is_unique[users.email]',
				'phone' => 'required|min_length[6]|max_length[20]',
				'address' => 'required|min_length[1]|max_length[100]',
				'password' => 'required|min_length[8]|max_length[255]',
				'password_confirm' => 'matches[password]',
				
			];

			//Validate VAT number
			$vatnumber = $this->request->getVar('vatnumber');
			$country = $this->request->getVar('country');

			if($country == 'Bulgaria'){
					$rules['vatnumber'] = [
						'rules' => 'required|min_length[11]|max_length[12]|is_unique[users.vatnumber]|validate_vat_number_bg',
						'errors' => [
							'is_unique' => 'The {field} is not a valid Bulgarian VAT number or it is already taken.',
						],
					];
			}

			if($country == 'Romania'){
					$rules['vatnumber'] = [
						'rules' => 'required|min_length[10]|max_length[12]|is_unique[users.vatnumber]|validate_vat_number_ro',
						'errors' => [
							'is_unique' => 'The {field} is not a valid Romanian VAT number or it is already taken.',
						],
					];
			}

			if (! $this->validate($rules)) {
				$data['validation'] = $this->validator;
			}else{
				
				
				$model = new UserModel();
				if($this->request->getVar('buyer'))
					$buyer=1;
				else
					$buyer=0;
				
				if($this->request->getVar('seller'))
					$seller=1;
				else
					$seller=0;
				
				
				$newData = [
					
					'companyname' => $this->request->getVar('companyname'),
					'vatnumber' => $this->request->getVar('vatnumber'),
					'country' => $this->request->getVar('country'),
					'district' => $this->request->getVar('district'),
					'city' => $this->request->getVar('city'),
					'address' => $this->request->getVar('address'),
					'firstname' => $this->request->getVar('firstname'),
					'lastname' => $this->request->getVar('lastname'),
					'email' => $this->request->getVar('email'),
					'website' => $this->request->getVar('website'),
					'phone' => $this->request->getVar('phone'),
					'password' => $this->request->getVar('password'),
					'contactemail' => $this->request->getVar('contactemail')
				
					
				];
				$model->save($newData);
				
				$user_id = $model->getInsertID();
				$new_user_url = "https://admin.zadio.bg/edituser/".$user_id; 

				// Prepare dynamic email data
				$email_data = [
					'companyname' => $this->request->getVar('companyname'),
					'vatnumber'   => $this->request->getVar('vatnumber'),
					'city'        => $this->request->getVar('city'),
					'phone'       => $this->request->getVar('phone'),
					'email'       => $this->request->getVar('email'),
					'website'     => $this->request->getVar('website'),
					'new_user_url' => $new_user_url,
				];
				$msg = view('emails/registration_email_zadio', $email_data);



				//sendMyMsg('cars@zadio.bg','cars@zadio.bg','New registration in cars.zadio.bg',$msg);
				

				// Send email to Zadio
				$email = service('email');
				$email->setTo('cars@zadio.bg');
				$email->setSubject('User registration');
				$email->setMessage($msg);
				$email->send();


				$msg = view('emails/registration_email_user');
				// Send email to user
				$email = service('email');
				$email->setTo($this->request->getVar('email'));
				$email->setSubject('Your ZadioCars account');
				$email->setMessage($msg);
				$email->send();
				
				return redirect()->to('/users/confirmreg');

			}
		}
		return view('user/register', $data);
	}
	
	public function countrydistricts($dummy){
        if ($this->request->isAJAX()) {

		$country = $this->request->getGet('country');
		$db = db_connect();
		$sqlstr="SELECT  `district_name`  FROM `district` WHERE  `country`='$country'";
		$query=$db->query($sqlstr);
		return $this->response->setJSON([
            'districts' => $query->getResult('array')
        ]);
		}


		return $this->response->setStatusCode(400, 'Bad Request');
		// //log_message('error', 'Ajax call');
        // $country=$this->request->getVar('country');
		// log_message('error', 'Value of country is '.$country);
		
		// $db = db_connect();
		// $sqlstr="SELECT  `district_name`  FROM `district` WHERE  `country`='$country'";
		// log_message('error',$sqlstr);
		// $query=$db->query($sqlstr);
		
		// echo(json_encode($query->getResult('array')));
		// exit;
	}
	
	public function confirmreg()
	{
		$data = [];
		$data = ['data' => ''];
		//
		/******************************************************
		$libpath= $_SERVER['DOCUMENT_ROOT'] . '/zadio/app';
		var_dump($libpath);exit;
		include_once $libpath.'/send_smtp.php';
		sendMyMsg('edi.hermann@lemonbyte.ro','edi.hermann@lemonbyte.ro','New registration in cars.zadio.bg','zzzzzzzzzz');
		
		$email = service('email');
		$email->setTo('edi.hermann@lemonbyte.ro');
		$email->setSubject('Email Test');
		$email->setMessage('Testing the email class5.');
		$email->send();
		******************************************************/
		//
		return view('user/confirmreg', $data);
	}
	
	
	public function profile(){
		$data = [];
		$data = ['data' => ''];
		helper(['form']);
		$model = new UserModel();
		
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }
		
		if ($this->request->getMethod() == 'POST') {
			$rules = [
				'firstname' => 'required|min_length[1]|max_length[20]',
				'lastname' => 'required|min_length[1]|max_length[20]',
				];

			
			if (! $this->validate($rules)) {
				$data['validation'] = $this->validator;
			}else{
				$hide_zadio=0;
				
				
				if($this->request->getVar('hide_zadio')=="on")
					$hide_zadio=1;
				//var_dump($hide_zadio);exit;
				$newData = [
					'id' => session()->get('id'),
					'companyname' => $this->request->getVar('companyname'),
					'vatnumber' => $this->request->getVar('vatnumber'),
					'country' => $this->request->getVar('country'),
					'district' => $this->request->getVar('district'),
					'city' => $this->request->getVar('city'),
					'address' => $this->request->getVar('address'),
					'firstname' => $this->request->getVar('firstname'),
					'lastname' => $this->request->getVar('lastname'),
					'email' => $this->request->getVar('email'),
					'website' => $this->request->getVar('website'),
					'phone' => $this->request->getVar('phone'),
					'contactemail' => $this->request->getVar('contactemail'),
					'commission_type'=> $this->request->getVar('coms'),
					'commission_abs'=> $this->request->getVar('commission_abs'),
					'commission_percent'=> $this->request->getVar('commission_percent')/100,
					'commission_min'=> $this->request->getVar('commission_min'),
					'hide_zadio'=> $hide_zadio
					];
				//var_dump($newData);exit;
				$model->save($newData);
				session()->setFlashdata('success', 'Company data successfuly updated');
				return redirect()->to('/dashboard');
			}
		}
		$data['user'] = $model->where('id', session()->get('id'))->first();
		
		//var_dump($data['user']);exit;
		$districts=$model->getDistricts(($data['user'])['country']);
		$data['districts']=$districts;
		
		return view('user/profile', $data);
	}
	
	public function changepwd(){
		$data = [];
		$data = ['data' => ''];
		$session = session();
		$usr = session()->get('id');
        if (!$usr>0) 
		{
	     $this->response->redirect(site_url('/login'));
		  exit;
        }
		
		helper(['form']);
		$model = new UserModel();
		if ($this->request->getMethod() == 'POST') {
			$rules = [];

			if($this->request->getPost('password') != ''){
				$rules['crtpassword'] = 'validateCrtPwd[username,crtpassword]';
				$rules['password'] = 'required|min_length[8]|max_length[255]';
				$rules['password_confirm'] = 'matches[password]';
				$errors = [
				'crtpassword' => [
					'validateCrtPwd' => 'Current password incorrect!'
				]
			];
				
			}
			if (! $this->validate($rules,$errors)) {
				$data['validation'] = $this->validator;
				
				
			}
			else{
				//check crtPwd
				$crtpassword=$this->request->getPost('crtpassword');
				
				$newData = [
					'id'=>$usr,
					'password' => $this->request->getPost('password')
					];
					$model->save($newData);
					session()->setFlashdata('success', 'Password successfuly updated');
					return redirect()->to('/cars');
			}
		}
		$data['user'] = $model->where('id', session()->get('id'))->first();
		return view('user/changepwd', $data);
	}
	
	public function logout(){
		session()->destroy();
		return redirect()->to('/');
	}
}
