<?php

const VATBG="0.20";
const BGNEUR="0.5154";


$vatbg=0.20;
$bgneur=0.5154;
$roneur=0.20;

load_commissions();

function front_url()
{
	return "https://cars.zadio.bg/";
}


function formatPhone($number)
{
	if(strlen($number) >= 10) {
	  if(substr($number,0,1)=='+')
	  {
		  $prefix=substr($number,0,4);
		  $number=substr($number,4);
		  $parts = str_split($number, 3);
		  $number = $prefix.' '. $parts[0] .' '. $parts[1] .' '. $parts[2];
	  }
	}
	return $number;
}

function formatCode($number)
{
	  //$parts = str_split($number, 3);
	  //$number = $parts[0] .'.'. $parts[1] .'.'. $parts[2].'.'. $parts[3];
	  return $number;
}

function seller_bgnBrut($priceBGN)
{
	return round($priceBGN*(1+VATBG));
}

function seller_eurNet($priceBGN) //fara tva
{
	return round($priceBGN*BGNEUR);
}

function seller_eurBrut($priceBGN) //fara tva
{
	return round($priceBGN*BGNEUR*(1+VATBG));
	
}

function load_commissions()
{
	//var_dump(session()->get('commission_abs'));exit;
	
	if(session()->get('commission_abs')==NULL)
	{
		$sqlstr="select commission_type, commission_type_deal, `commission_abs`, `commission_percent`, `commission_min`,`commission_abs_deal`, `commission_percent_deal`, `commission_min_deal` from company_details limit 1";
		$db = db_connect();
		$query = $db->query($sqlstr);
		$res= $query->getResult('array');
		foreach($res as $row)
		{
			session()->set($row);
			//var_dump(session()->get());exit;
			return;
		}
	}
	
}

function bgnBrut($priceBGN) //fara tva
{
	return round($priceBGN*(1+VATBG));
}


function public_eurNet($priceBGN) //fara tva
{
	$session = session();
	
	if(!session()->get('seller') && !session()->get('buyer'))
	{
		if($session->get('commission_type')==0)
		{	
			$commission_abs=0;
			$commission_percent=0;
			$commission_min=0;
			return(round($priceBGN*BGNEUR,2));
		}
		
		if($session->get('commission_type')==1)
		{	
			$commission_abs=$session->get('commission_abs');
			$commission_percent=$session->get('commission_abs');
			$commission_min=0;
			return(round(($priceBGN+$commission_abs)*BGNEUR,2));
		}
		
		if($session->get('commission_type')==2)
		{	
			$commission_abs=0;
			$commission_percent=$session->get('commission_percent');
			$commission_min=$session->get('commission_min_deal');
			
			if($priceBGN*(1+$commission_percent)>$commission_min)
				return round($priceBGN*(1+$commission_percent)*BGNEUR,2);
			else
				return round(($priceBGN+$commission_min)*BGNEUR,2);
			
		}
	}
	else
		return null;
 }


function public_eurBrut($priceBGN) //fara tva
{
	return round(public_eurNet($priceBGN)*(1+VATBG),2);
}
 

function buyer_eurNet($priceBGN) //fara tva
{
	$session = session();
	

	if($session->get('commission_type_deal')==0)
	{	
		//var_dump('0');exit;
		return(round($priceBGN*BGNEUR,2));
		
	}
	
	if($session->get('commission_type_deal')==1)
	{	
		//var_dump($session->get('commission_abs_deal'));exit;
		$commission_abs=$session->get('commission_abs_deal');
		return round(($priceBGN+$commission_abs)*BGNEUR,2);
	}
	
	if($session->get('commission_type_deal')==2)
	{	
		//var_dump('2');exit;
		$commission_percent=$session->get('commission_abs_deal');
		$commission_min=$session->get('commission_min_deal');
		
		if($priceBGN*(1+$commission_percent)>$commission_min)
			return round($priceBGN*(1+$commission_percent)*BGNEUR,2);
		else
			return round(($priceBGN+$commission_min)*BGNEUR,2);
		
	}

 }

function buyer_eurBrut($priceBGN) //fara tva
{
	return round(buy_eurNet($priceBGN)*(1+VATBG),2);
}




function client_eurNet($priceBGN) //fara tva
{
	$session = session();
	$commission_abs=$session->get('commission_abs_sale');
	$commission_percent=$session->get('commission_percent_sale');
	$commission_min=$session->get('commission_min_sale');
	$priceEUR=buyer_eurNet($priceBGN);
	
	if($commission_abs>0)
		return round($priceEUR+$commission_abs);
	else
	{
		if($commission_abs*$commission_percent > $commission_min)
			return round($priceEUR*(1+$commission_percent),2);
		else
			return round($priceEUR +$commission_min,2);
	}
}

function client_eurBrut($priceBGN) //fara tva
{
	return round(buyer_eurNet($priceBGN)*(1+VATBG),2);
}


function final_eurNet($priceBGN) //fara tva
{
	if(session()->get('seller')==1)
	{
		return seller_eurNet($priceBGN);
	}
	else
	{
		if(session()->get('buyer')==1)
		{
			return buyer_eurNet($priceBGN);
		}
	
		else //not seller, not buyer
		{
			return public_eurNet($priceBGN);
		}
	}
}

function final_eurBrut($priceBGN) //fara tva
{
	return round(final_eurNet($priceBGN)*(1+VATBG),2);
}






?>